//
//  RequestChatUtils.swift
//  Chat Application 1
//
//  Created by Avaya on 22/09/2016.
//  Copyright © 2016 Avaya. All rights reserved.
//

import Foundation
import SwiftyJSON

public class RequestChatUtils{
    
    let routePoint: String?
    let workFlow : String?
    let workRequestId : String?
    let authToken : String?
    
    init(){
        routePoint = ""
        workFlow = ""
        workRequestId = ""
        authToken = ""
    }
    
    init(routePoint: String,workFlow: String,workRequestId: String,authToken: String){
        self.routePoint = routePoint
        self.workFlow = workFlow
        self.workRequestId = workRequestId
        self.authToken = authToken
    }
    
    
    func buildRequestChatRequest(authToken: String, name: String, email: String, phoneNumber: String, area: String, country: String, attributes: [String], customFields: [CustomFields], transcript: Bool) -> String{
        
        let body = RequestChatRequest()
        body.requestTranscript = transcript
        body.routePointIdentifier = "Default"
        body.DeviceType = "iOS"
        body.workFlowType = workFlow
        body.workRequestId = workRequestId
        body.priority = "5"
        
        body.intrinsics = buildRequestChatIntrinsicsWIthDefaultValues(name: name,email: email,phoneNumber: phoneNumber, area: area, country: country, attributes: attributes,customFields: customFields)
    
        
        
        let message =  RQRWrapper()
        message.apiVersion = "1.0"
        message.type = "request"
        message.body = body
        message.authToken = authToken

        
        
        let jsonString: String? = message.toJSONString(prettyPrint: true)
        
        return jsonString!
    }
    
    
    private func buildRequestChatIntrinsicsWIthDefaultValues(name: String, email:  String, phoneNumber: String, area: String, country: String, attributes: [String], customFields: [CustomFields]) -> Intrinsics{
        let intrinsics = Intrinsics()
        intrinsics.name = name
        intrinsics.email = email
        intrinsics.area = area
        intrinsics.phoneNumber = phoneNumber
        intrinsics.country = country
        intrinsics.channelAttribute = "Chat"
        intrinsics.attributes = attributes
        intrinsics.customFields = customFields
        
        
        return intrinsics
    }
    
    func mixLists(list1: [String],_ list2 :[String]) -> [String]{
        
        let list1Size = list1.count
        let list2Size = list2.count
        
        var list3 = [String]()
        
        let max = getLargestList(a: list1Size, list2Size)
        
        
        for i in 0 ..< max{
            if i < list1Size && i < list2Size {
                list3.append(list1[i])
                list3.append(list2[i])
            }
            else if i < list1Size {
                list3.append(list1[i])
            }
            else {
                list3.append(list2[i])
            }
        }
        
        return list3
    }
    
    func getLargestList(a: Int, _ b: Int) -> Int{
        
        var max: Int?
        if a >= b{
            max = a
        }
        else{
            max = b
        }
        return max!
    }
    
}
